#!/usr/local/bin/wish

foreach Rep [list "./" "/home/ripp/gscope/"] {
    if {[file exists "$Rep/gscope_outils.tcl"]} { break }
}
source "$Rep/gscope_outils.tcl"

package require Img

proc RotateText {} {

    set K [UnCanva]
    
    package require BLT
    ::blt::bitmap compose myNewBitmap "this is a text" \
	    -font "Arial 10 bold" \
	    -rotate 60 \
	    -justify left
    $K create bitmap 50 50 -bitmap myNewBitmap \
	    -foreground blue \
	    -anchor nw \
	    
}

proc Jivaro {FichierSource O} {

    set Source [image create photo -file $FichierSource]
    set W [image width $Source]
    set H [image height $Source]
    
    set OW $O
    set OH 48
    
    if { [expr $W-$OW] > [expr (($H-$OH)*4)/3]} {
	set HS $H
	set WS [expr $OW+(($HS-$OH)*4)/3]
    } else {
	set WS $W
	set HS [expr $OH+(($WS-$OW)*3)/4]
    }
    
    set Couleur [format "#%2.2x%2.2x%2.2x" 255 100 100]
    
    $Source put $Couleur -to 0 $OH $W [expr $OH+8]
    $Source put $Couleur -to 0 [expr $HS-8] $W $HS
    $Source put $Couleur -to $OW 0 [expr $OW+8] $H
    $Source put $Couleur -to $WS 0 [expr $WS-8] $H
    
    set Tmp [image create photo]
    $Tmp copy $Source -subsample 8
            
    set K [UnCanva 800 800 800 800]
    $K create image 400 400 -image $Tmp
    return
    regsub ".canvas" $K "" Fenetre
    set Reponse [OuiOuNon "Ok ?"]
    
    destroy $Fenetre
    if {$Reponse } {
	image delete $Source 
	image delete $Tmp 

	regsub {B *} $FichierSource "A" FichierDestin

	set Bonne [image create photo -file $FichierSource]
	set Destin [image create photo]
	$Destin copy $Bonne -from $OW $OH $WS $HS
	$Destin write $FichierDestin -format jpeg 
	image delete $Bonne 
	image delete $Destin
	return $FichierDestin
    }
    incr O 25
    if {$O>50} { set O 0 }
    image delete $Source 
    image delete $Tmp 
    return [Jivaro $FichierSource $O]

    return $Reponse
    
    set NJ 1
    foreach I [NombresEntre 1 100] {
	set C 0
	foreach J [NombresEntre 1 $NJ] {
	    ScanLaListe [$Source get $I $J] R V B
	    incr C $R
	    incr C $V
	    incr C $B
	}
	set Cumul($I) [expr $C/(3*$NJ)]
	lappend LesCIs [expr $C/(3*$NJ)]
    }

}

if {0} {RotateText}

if {1} {
    #set Rep "s:/Phototheque/Wiosna/Rzeszow/ScanRzeszow"
    set Rep "./"
    
    foreach Fichier [glob "$Rep/toto.ps"] {
	Jivaro $Fichier 0
    }
}

