#!/usr/local/bin/wish

#rR Photorama.tcl mis  jour 2006/04/24 19:04:00

proc NikonViewWithLink {{Rep ""}} {
    if {$Rep==""} { set Rep [ChoixDuRepertoire] }
    FaireLire $Rep
    set LesFichiers [glob -nocomplain "$Rep/page*.htm" "$Rep/*/page*.htm"]
    set Fichier [ChoixParmi $LesFichiers]
    if {$Fichier==""} { return ""}
    set RefFullSize ""
    set EmmettreMessage 1
    foreach Ligne [LesLignesDuFichier $Fichier] {
        if {$EmmettreMessage && [regexp "</font></td>" $Ligne]} {
            set EmmettreMessage 0
            regsub  "</font></td>" $Ligne \
		    "</font><br/>Click on the lower right corner to see the full size picture</td>" Ligne
        }
        Espionne $Ligne
        if {[regexp {<a href=\"images/[^>]+>} $Ligne Reference]} {
            regsub "images/" $Reference "../" RefFullSize
            Espionne "+++++++++++++++++++++++++++++= $Reference $RefFullSize"
        }       
        if {$RefFullSize!="" && [regexp {<img src=\"parts/mbf4[^>]+>} $Ligne Coin]} {
            regsub ">$" $Coin "" CoinSans
            regsub "$CoinSans" $Ligne "$RefFullSize$CoinSans border=\"0\"></a" Ligne
        }
        Espionne $Ligne
        lappend LeNouveau $Ligne
    }
    
    set Nouveau ""
    while {$Nouveau==""} {
	set Nouveau [Entre $Fichier]
	if {$Nouveau=="" && [OuiOuNon "On ne sauve pas ?"]} { return "" } 
    }
    return [SauveLesLignes $LeNouveau dans $Nouveau]
}

set Script [info script]
set PhotoramaDir [file dirname $Script]

set Luxe 0
set LesPoss [list \
	"./gscope_outils.tcl" \
	"$PhotoramaDir/gscope_outils.tcl" \
	"$PhotoramaDir/../gscope_outils.tcl" ]
foreach FichierGscopeOutils $LesPoss {
    if { ! [file exists $FichierGscopeOutils]} { continue }
    source $FichierGscopeOutils
    set Luxe 1
    break
}

set AmelioreNikon [expr $Luxe && [OuiOuNon "J'ameliore les pages de NikonView ?" ]]


set f [open "$PhotoramaDir/PhotoramaPatron.html" "r"]
set TextePhotorama [read -nonewline $f]
close $f

set InitDir ""
set  PhotoramaLog "$PhotoramaDir/Photorama.log"
if {[file exists $PhotoramaLog]} {
    set f [open $PhotoramaLog "r"]
    set LesLignes [split [read -nonewline $f] "\n"]
    set InitDir [lindex $LesLignes end]
    close $f    
}
if {$InitDir==""} {
    foreach Disk [list s f] {
    set InitDir "Disk:/Phototheque"
	if {[file exists "Disk:/Phototheque"]} {
	    break
	}
	set InitDir ""
    }
}

set Rep [tk_chooseDirectory -initialdir $InitDir]

if {$AmelioreNikon} {
    NikonViewWithLink $Rep
    if { ! [OuiOuNon "Je fait aussi le Photorama ?"]} { exit }
}

set NouveauNom "Photorama.html"

set I 1
set NouveauFichier "$Rep/$NouveauNom"
while {[file exists $NouveauFichier]} {
    incr I
    regsub {[0-9]*\.html$} $NouveauNom "[format "%2.2d" $I].html" NouveauNom
    set NouveauFichier "$Rep/$NouveauNom"
}

set LesImages {}
foreach Fichier [glob -nocomplain $Rep/*] {
    set Nom [file tail $Fichier]
    if { ! [regexp -nocase "\.jpg" $Nom]} { continue }
    lappend LesImages "\"$Nom\""
}


set TexteImages [join $LesImages ",\n"]

regsub "put here the list of the image files" $TextePhotorama $TexteImages NouveauPhotorama

set f [open "$Rep/Photorama.html" "w"]
puts $f $NouveauPhotorama
close $f

catch {
    set f [open $PhotoramaLog "w"]
    puts $f $Rep
    close $f
}

exit


