#!/usr/local/bin/tclsh

proc MoisAlpha M {
    set M [Base10 $M]
    set Alphabet ".ABCDEFGHIJKLMNOPQRSTUVWXYZ"
    return [string index $Alphabet $M]
}

proc RenommePhotos {} {
    global env
    global GscopeDir 
    if {[info exists env(GSCOPEDIR)]} {
	set GscopeDir [set env(GSCOPEDIR)]
    } else {
	set GscopeDir "./"
    }
    source $GscopeDir/gscope_outils.tcl
    
    set Minuscule 1
    FaireLire "Bonjour, \nAttention Minuscule = $Minuscule\n ce programme permet de renommer les fichiers .jpg\n\
	    PICT1234 devient S5B12340\n\
	    DSCN1234 devient R4L12340\n\
	    S comme Sophie, R comme Raymond\n\
	    S5B si on est en 2005 fevrier, R4L si on est en 2004 decembre\n\n\
	    Salut.\n\
	    ............... Raymond\n\n\
	    A janvier\n\
	    B fevrier\n\
	    C mars\n\
	    D avril\n\
	    E mai\n\
	    F juin\n\
	    G juillet\n\
	    H aout\n\
	    I septembre\n\
	    J octobre\n\
	    K novembre\n\
	    L decembre\n\
	    "
    
    set Possible "F:/Phototheque"
    if { ! [file exists $Possible]} { set Possible "S:/Phototheque" }
    set Rep [ChoixDuRepertoire "$Possible/AlbumsClasses"]
    if {$Rep==""} { FaireLire "On se quitte. Salut."; return } 
    NousAllonsAuBoulot $Rep
    
    set Date [Date]
    set Annee [string range $Date 0 3]
    set Mois  [string range $Date 4 5]
    set Jour  [string range $Date 6 7]
    
    set L "X"
    set DouP "XXXX"
    set LesDSCNs [glob -nocomplain "DSCN*.jpg"]
    set LesPICTs [glob -nocomplain "PICT*.jpg"]
    if {[llength $LesDSCNs]>0} { set DouP "DSCN" ; set L "R"}
    if {[llength $LesPICTs]>0} { set DouP "PICT" ; set L "S"}

    set A [string range $Annee 3 3]
    set M [string range $Mois  0 1]
    set Pref "$L$A[MoisAlpha $M]"

    
    set Nom "${DouP}abcd" 
    ScanLaListe [split $Nom ""] dd ss cc nn a b c d
    
    set Methode0 "Methode0 on renumerote dans l'ordre apres ${DouP}xxxx.jpg"
    set Methode1 "Methode1 $Nom devient ${Pref}$a$b$c${d}0"    
    set Methode2 "Methode2 (ne sert plus) Je recherche tous les R3L et les change en R3K ?"    
    set Methode3 "Methode3 $Nom devient ${Pref}$a$b$c${d}0 en changeant $Pref"    
    set Methode4 "Methode4 toto.jpg devient xx00toto.jpg en supprimant les blancs "    

    if {[OuiOuNon "Je choisis $Methode1"]} {
	set Methode $Methode1
    } else {
	if {[OuiOuNon "On arrete tout ?"]} { return }
	set Methode ""
	while {$Methode==""} {
	    set Methode [ChoixParmi [list $Methode0 $Methode1 $Methode2 $Methode3 $Methode4]]
	    if {$Methode=="" && [OuiOuNon "On arrete tout ?"] } { return } 
	}
    }
    scan $Methode "%s" Methode

    if {$Methode=="Methode0"} {
	FaireLire "Donner le nom (PICT0001 ou DSCN0234) a partir duquel je renumerote sur 4 chiffres"
	set Premier [Entre "PICT0001"]
	regsub {[0-9]+$} $Premier "" Suff
	regsub $Suff $Premier "" Numero
	set Numero [Base10 $Numero]

	foreach F [lsort [glob "$DouP*.JPG"]] {
	    set Q [file tail $F]
	    regexp {\..+$} $Q Ext
	    regsub "$Ext$" $Q "" Nom
	    if {$Minuscule} { set Ext [string tolower $Ext] }
	    set NouveauNom [format "%s%4.4d%s" $Suff $Numero $Ext]
	    lappend LesBon "$NouveauNom"
	    lappend LesTmp "tmp_$NouveauNom"
	    file rename $F "tmp_$NouveauNom"
	    incr Numero 1
	}
	foreach Tmp $LesTmp Bon $LesBon {
	    file rename $Tmp $Bon
	}

    }
    
    if {$Methode=="Methode3"} {
	set Pref [Entre $Pref]
	set Methode "Methode1"
    }
    if {$Methode=="Methode1"} {
	foreach F [glob -nocomplain "${DouP}*"] {
	    set Q [file tail $F]
	    if { ! [regexp -nocase ".jpg$" $Q Ext]} { continue }
	    regsub "$Ext$" $Q "" Nom
	    if {$Minuscule} { set Ext [string tolower $Ext] }
	    ScanLaListe [split $Nom ""] dd ss cc nn a b c d
	    set NouveauNom "${Pref}$a$b$c${d}0"
	    set NouveauF "$NouveauNom$Ext"
	    file rename $F $NouveauF
	}
    }

    if {$Methode=="Methode2"} {
	foreach Rep [list "." "./www01/images" "./www01/thumbs"] {
	    foreach F [glob "$Rep/R3L*"] {
		set Dir [file dirname $F]
		set Que [file tail $F]
		regsub "R3L" $Que "R3K" NewQue 
		set NouveauF "$Dir/$NewQue"
		file rename $F $NouveauF
	    }
	}
	set FichierHTML "./www01/page1.htm"
	if {[file exists $FichierHTML]} { 
	    set HTML [ContenuDuFichier $FichierHTML]
	    regsub -all "R3L" $HTML "R3K" NouveauHTML
	    Espionne $NouveauHTML
	    Sauve $NouveauHTML dans $FichierHTML
	}
    }

    if {$Methode=="Methode4"} {
	set I 1000
	foreach F [lsort [glob "*.jpg"]] {
	    incr I 100
	    set Queue [file tail $F]
	    set NewQueue $Queue
	    regsub -all " " $NewQueue "" NewQueue
	    regsub -nocase "Rzeszow2005" $NewQueue "" NewQueue
	    set NouveauF "$I$NewQueue"
	    FaireLire "file rename $F $NouveauF"
	    file rename $F $NouveauF
	}
    }

    OnRevientDuBoulot
    return
}

RenommePhotos

exit
