#!/usr/local/bin/tclsh

proc MoisAlpha M {
    set M [Base10 $M]
    set Alphabet ".ABCDEFGHIJKLMNOPQRSTUVWXYZ"
    return [string index $Alphabet $M]
}

proc RenommeDSCN {} {
    global env
    global GscopeDir 
    if {[info exists env(GSCOPEDIR)]} {
	set GscopeDir [set env(GSCOPEDIR)]
    } else {
	set GscopeDir "./"
    }
    source $GscopeDir/gscope_outils.tcl
    
    
    set Rep [ChoixDuRepertoire "S:/Phototheque/AlbumsClasses"]
    NousAllonsAuBoulot $Rep
    
    set Date [Date]
    set Annee [string range $Date 0 3]
    set Mois  [string range $Date 4 5]
    set Jour  [string range $Date 6 7]
    
    set A [string range $Annee 3 3]
    set M [string range $Mois  0 1]
    set L "R"
    set Pref "$L$A[MoisAlpha $M]"
    
    set Nom "DSCNabcd" 
    ScanLaListe [split $Nom ""] dd ss cc nn a b c d
    
    set Methode0 "Methode0 $Nom devient DSCNA$b$c$d puis par ordre a partir de ${Pref}0001"
    set Methode1 "Methode1 $Nom devient ${Pref}$a$b$c${d}0"    
    set Methode2 "Methode2 Je recherche tous les R3L et les change en R3K ?"    
    set Methode3 "Methode3 $Nom devient ${Pref}$a$b$c${d}0 en changeant $Pref"    

    if {[OuiOuNon "Je choisis $Methode1"]} {
	set Methode $Methode1
    } else {
	
	set Methode ""
	while {$Methode==""} {
	    set Methode [ChoixParmi [list $Methode0 $Methode1 $Methode2 $Methode3]]
	    if {$Methode=="" && [OuiOuNon "On arrete tout ?"] } { return } 
	}
    }
    scan $Methode "%s" Methode

    if {$Methode=="Methode0"} {
	foreach F [glob DSCN*] {
	    regsub "DSCN0" $F "DSCNA" NF
	    set VraiNom($NF) $F
	    lappend LesFs $NF
	}
	set LesFs [lsort $LesFs]
	set Numero 0
	foreach F $LesFs {
	    set Q [file tail $F]
	    if { ! [regexp -nocase ".jpg" $Q Ext]} { continue }
	    regsub "$Ext$" $Q "" Nom
	    set NouveauNom [format "%s%5.5d" $Pref $Numero]
	    set NouveauF "$NouveauNom$Ext"
	    file rename [set VraiNom($F)] $NouveauF
	    incr Numero 5
	}
    }
    
    if {$Methode=="Methode3"} {
	set Pref [Entre $Pref]
	set Methode "Methode1"
    }
    if {$Methode=="Methode1"} {
	foreach F [glob DSCN*] {
	    set Q [file tail $F]
	    if { ! [regexp -nocase ".jpg" $Q Ext]} { continue }
	    regsub "$Ext$" $Q "" Nom
	    ScanLaListe [split $Nom ""] dd ss cc nn a b c d
	    set NouveauNom "${Pref}$a$b$c${d}0"
	    set NouveauF "$NouveauNom$Ext"
	    file rename $F $NouveauF
	}
    }

    if {$Methode=="Methode2"} {
	foreach Rep [list "." "./www01/images" "./www01/thumbs"] {
	    foreach F [glob "$Rep/R3L*"] {
		set Dir [file dirname $F]
		set Que [file tail $F]
		regsub "R3L" $Que "R3K" NewQue 
		set NouveauF "$Dir/$NewQue"
		file rename $F $NouveauF
	    }
	}
	set FichierHTML "./www01/page1.htm"
	if {[file exists $FichierHTML]} { 
	    set HTML [ContenuDuFichier $FichierHTML]
	    regsub -all "R3L" $HTML "R3K" NouveauHTML
	    Espionne $NouveauHTML
	    Sauve $NouveauHTML dans $FichierHTML
	}
    }

    OnRevientDuBoulot
    return
}

RenommeDSCN

exit
